<?php
/*
Plugin Name: WooCommerce Accept Extra Terms
Plugin URI: http://codection.com
Description: This plugin adds another terms option to accept extra terms
Author: Codection
Version: 1.0
Author URI: http://codection.com
*/

function codection_plugin_path() {
  	return untrailingslashit( plugin_dir_path( __FILE__ ) );
}
 
add_filter( 'woocommerce_locate_template', 'myplugin_woocommerce_locate_template', 10, 3 );
function myplugin_woocommerce_locate_template( $template, $template_name, $template_path ) {
	global $woocommerce;

	$_template = $template;

	if ( ! $template_path ) 
		$template_path = $woocommerce->template_url;

	$plugin_path  = codection_plugin_path() . '/woocommerce/';

	$template = locate_template( array( $template_path . $template_name, $template_name ) );

	if ( ! $template && file_exists( $plugin_path . $template_name ) )
		$template = $plugin_path . $template_name;

	if ( ! $template )
		$template = $_template;

	return $template;
}

add_filter( "woocommerce_get_settings_checkout", "codection_settings_checkout", 10 , 1 );
function codection_settings_checkout( $settings ){
	$i = 0;

	$new_setting = array(
				'title'    => __( 'Extra terms and Conditions', 'codection' ),
				'desc'     => __( 'If you define a extra "Terms" page the customer will be asked if they accept them when checking out.', 'codection' ),
				'id'       => 'woocommerce_extra_terms_page_id',
				'default'  => '',
				'class'    => 'wc-enhanced-select-nostd',
				'css'      => 'min-width:300px;',
				'type'     => 'single_select_page',
				'desc_tip' => true,
				'autoload' => false
			);

	foreach ( $settings as $setting ) {
		if( $setting["id"] == "woocommerce_terms_page_id" ){
			array_insert( $settings, $new_setting, $i + 1 );
			break;
		}

		$i++;
	}

	return $settings;
}	

add_action( 'woocommerce_after_checkout_validation', 'codection_checkout_field_process');
function codection_checkout_field_process() {
    if ( $_POST['abonne'] != "activated" )
        wc_add_notice( 'Du skal acceptere vores abonnementsbetingelserne.' , 'error' );
}

if( !function_exists( "array_insert" ) ):
	function array_insert(&$array,$element,$position=null) {
	  if (count($array) == 0) {
	    $array[] = $element;
	  }
	  elseif (is_numeric($position) && $position < 0) {
	    if((count($array)+position) < 0) {
	      $array = array_insert($array,$element,0);
	    }
	    else {
	      $array[count($array)+$position] = $element;
	    }
	  }
	  elseif (is_numeric($position) && isset($array[$position])) {
	    $part1 = array_slice($array,0,$position,true);
	    $part2 = array_slice($array,$position,null,true);
	    $array = array_merge($part1,array($position=>$element),$part2);
	    foreach($array as $key=>$item) {
	      if (is_null($item)) {
	        unset($array[$key]);
	      }
	    }
	  }
	  elseif (is_null($position)) {
	    $array[] = $element;
	  }  
	  elseif (!isset($array[$position])) {
	    $array[$position] = $element;
	  }
	  $array = array_merge($array);
	  return $array;
	}
endif;

function codection_subscription_in_cart(){
	foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
        $product = $cart_item['data'];
		$_product = wc_get_product( $product->id );
		
		if( $_product->is_type( 'subscription' ) || $_product->is_type( 'variable-subscription' ) ) {
			return true;
		}
	}	

	return false;
}
